// SSDV SENDER 160x120
// ARDUINO DUE

#include <arduino.h>
#include <SPI.h>
#include <SD.h>
#include <DueTimer.h>
#include "JPEGDecoder.h"

File myFile;
#define chipSelect 4

#define  CLK   6
#define  FQ    7
#define  DATA  8
#define  RST   9
long oFreq = 21390; //kHz

//packet
uint8_t   startMk    = 0x68;   //start marker
uint8_t   LField     = 0xA3;   //length 163d
uint8_t   CField;              //control, function
uint8_t   AField     = 0xFF;   //a1, address
uint8_t   CIField    = 0x03;   //a2, control information
uint8_t   payloadLen = 0xA0;   //160d
uint8_t   checkSum;
uint8_t   stopMk     = 0x16;   //stop marker

//controls
uint8_t  sSq;
boolean  snd;
int      ti;
byte     telegramNumber;

//data
uint8_t frameBuf[19200]; //160*120
uint8_t outgoingByte;

//dds
void shortPulse (char PIN)
{
        digitalWrite(PIN, 1);
        digitalWrite(PIN, 0);
}

void setFreq(double freq)
{
        //--calculate
        int32_t d_Phase = freq * pow(2, 32) / 125000000;
        //--send first 32bit
        for (int i=0; i<32; i++, d_Phase>>=1)
        {
                if(d_Phase & 1 == 1)
                {
                        digitalWrite(DATA, HIGH); //--data
                }
                else
                {
                        digitalWrite(DATA, LOW); //--data
                }
                shortPulse(CLK);
        }
        //--send rest 8bit
        digitalWrite(DATA, LOW); //--data
        for (int i=0; i<8; i++)
        {
                shortPulse(CLK);
        }
        //--finish
        shortPulse(FQ);
}

void setup()
{
  //SERIAL
  char ch;
  
  Serial.begin(9600); //for Debug
  Serial1.begin(38400); //Camera Serial
  delay(100);
  while(Serial.available())
  {
          ch = Serial.read(); //flush
  }
  while(Serial1.available())
  {
          ch = Serial1.read(); //flush
  }
  Serial.println("SERIAL READY");
  
  //DDS
  pinMode(CLK, OUTPUT);
  pinMode(FQ, OUTPUT);
  pinMode(DATA, OUTPUT);
  pinMode(RST, OUTPUT);
  //--dds reset
  shortPulse(RST);
  shortPulse(CLK);
  //--change mode
  shortPulse(FQ);
  //--kHz2Hz
  oFreq = oFreq * 1000;
  
  //PINS
  pinMode(10, OUTPUT);
  pinMode(13, OUTPUT);   //TTL
  pinMode(31, OUTPUT);   //ERROR LAMP
  pinMode(33, OUTPUT);   //SHOT LAMP
  digitalWrite(31, LOW);
  digitalWrite(33, LOW);
  
  pinMode(47, INPUT);
  pinMode(49, INPUT);
  digitalWrite(47, HIGH);   //INTERNAL PULL UP
  digitalWrite(49, HIGH);   //INTERNAL PULL UP
  
  //SD
  if (!SD.begin(chipSelect))
  {
          Serial.println("ERROR: INSERT SD CARD AND RESTART");
          digitalWrite(31, HIGH);
          return ;
  }
  Serial.println("SD CARD INITIALIZED");
  Serial.println();
  
  //CAM
  //--cam reset
  Serial1.print((char)0x56);
  Serial1.print((char)0x00);
  Serial1.print((char)0x26);
  Serial1.print((char)0x00);
  delay(1900);
  
  while(!Serial1.available()){ }
  while(Serial1.available())
  {
          Serial.print(Serial1.read(), HEX);
          Serial.print(" ");
  }
  Serial.println();
  
  //--cam setSize
  Serial1.print((char)0x56);
  Serial1.print((char)0x00);
  Serial1.print((char)0x54);
  Serial1.print((char)0x01);
  Serial1.print((char)0x22); //160*120
  delay(100);
  
  while(!Serial1.available()){ }
  while(Serial1.available())
  {
          Serial.print(Serial1.read(), HEX);
          Serial.print(" ");
  }
  Serial.println();
  
  Serial.println("JPEG CAMERA INITIALIZED");
  Serial.println();
  
  //TIMER
  Timer1.attachInterrupt(timer1_interrupt).start(333); //300baud
  delay(100);
}

void jpegTake(void)
{
        byte start_addr_m;
        byte start_addr_l;
        boolean jpegEnd;
        int  jpegEndPos;
        int  byteCount;
        byte incomingByte;
        byte jpegArray[20001];
        boolean err;
        int  i;
        
        Serial.println();
        Serial.println("NEW FILE");
        
        //--cam takePhoto
        digitalWrite(33, HIGH);
        Serial1.print((char)0x56);
        Serial1.print((char)0x00);
        Serial1.print((char)0x36);
        Serial1.print((char)0x01);
        Serial1.print((char)0x00);
        delay(100);
        
        while(!Serial1.available()){ }
        digitalWrite(33, LOW);
        while(Serial1.available())
        {
                Serial.print(Serial1.read(), HEX);
                Serial.print(" ");
        }
        Serial.println();
        
        //--cam readSize
        Serial1.print((char)0x56);
        Serial1.print((char)0x00);
        Serial1.print((char)0x34);
        Serial1.print((char)0x01);
        Serial1.print((char)0x00);
        delay(100);
        
        while(!Serial1.available()){ }
        while(Serial1.available())
        {
                Serial.print(Serial1.read(), HEX);
                Serial.print(" ");
        }
        Serial.println();
        
        //--cam readContent
        start_addr_m = 0x00;
        start_addr_l = 0x00;
        jpegEnd = false;
        i = 0;
        
        while(!jpegEnd)
        {
                /*
                Serial.print("start_addr: ");
                Serial.print(start_addr_m, HEX);
                Serial.print(" ");
                Serial.print(start_addr_l, HEX);
                Serial.println();
                delay(10);
                */
                Serial1.print((char)0x56);
                Serial1.print((char)0x00);
                Serial1.print((char)0x32);
                Serial1.print((char)0x0C);
                Serial1.print((char)0x00);
                Serial1.print((char)0x0A);
                Serial1.print((char)0x00);
                Serial1.print((char)0x00);
                
                Serial1.print((char)start_addr_m);  //MM
                Serial1.print((char)start_addr_l);  //MM
                
                Serial1.print((char)0x00);
                Serial1.print((char)0x00);
                Serial1.print((char)0x00);  //KK
                Serial1.print((char)0x20);  //KK (DEC:32)
                Serial1.print((char)0x00);  //XX
                Serial1.print((char)0x0A);  //XX
                
                while(!Serial1.available()){ }
                delay(22); //10ms at least
                
                byteCount = 0;
                while(Serial1.available())
                {
                        incomingByte = Serial1.read();
                        /*
                        Serial.print(incomingByte, HEX);
                        Serial.print(" ");
                        */
                        if(byteCount >=5 && byteCount <=36)
                        {
                                jpegArray[i] = incomingByte;
                                if(jpegArray[i - 1] == 0xFF && jpegArray[i] == 0xD9)
                                {
                                        /*
                                        Serial.println("CAUGHT FFD9!");
                                        */
                                        jpegEndPos = i;
                                        jpegEnd = true;
                                }
                                i++;
                        }
                        byteCount++;
                }
                /*
                Serial.println();
                */
                if(start_addr_l == 0xE0)
                {
                        start_addr_l = 0x00;
                        start_addr_m += 0x01;
                }
                else
                {
                        start_addr_l += 0x20; //DEC:32
                }
        }
        
        //--cam stop
        Serial1.print((char)0x56);
        Serial1.print((char)0x00);
        Serial1.print((char)0x36);
        Serial1.print((char)0x01);
        Serial1.print((char)0x03);
        delay(100);
        
        while(!Serial1.available()){ }
        while(Serial1.available())
        {
                Serial.print(Serial1.read(), HEX);
                Serial.print(" ");
        }
        Serial.println();
        
        //--jpeg fileSave
        err = false;
        myFile = SD.open("SSTV.JPG", FILE_WRITE | O_TRUNC);
        if(myFile)
        {
                for(i = 0; i <= jpegEndPos; i++)
                {
                        myFile.write(jpegArray[i]);
                }
        }
        else
        {
                Serial.println("CAN'T OPEN FILE");
                err = true;
        }
        myFile.close();
        
        if(err == true)
        {
                digitalWrite(31, HIGH);
                while(1);
        }
        else
        {
                Serial.println("JPEG FILE SAVED");
                Serial.println();
        }
}

void jpegDecode(void)
{
        char str[100];
        char filename[] = "SSTV.JPG";
        uint8 *pImg;
        int x,y,bx,by;
        
        float   pxGr;
        uint8_t pxGr_;
        int i;
        
        // Decoding start
        JpegDec.decode(filename,0);
        
        // Image Information
        Serial.print("Width     :");
        Serial.println(JpegDec.width);
        Serial.print("Height    :");
        Serial.println(JpegDec.height);
        Serial.print("Components:");
        Serial.println(JpegDec.comps);
        Serial.print("MCU / row :");
        Serial.println(JpegDec.MCUSPerRow);
        Serial.print("MCU / col :");
        Serial.println(JpegDec.MCUSPerCol);
        Serial.print("Scan type :");
        Serial.println(JpegDec.scanType);
        Serial.print("MCU width :");
        Serial.println(JpegDec.MCUWidth);
        Serial.print("MCU height:");
        Serial.println(JpegDec.MCUHeight);
        Serial.println("");
        
        // Output CSV
        sprintf(str,"#SIZE,%d,%d",JpegDec.width,JpegDec.height);
        Serial.println(str);
        
        // Image size error
        if(JpegDec.width != 160 || JpegDec.height != 120)
        {
                digitalWrite(31, HIGH);
                Serial.println("ERROR: PICTURE SIZE SHOULD BE 160*120") ;
                while(1);
        }
        
        // Clear buffer
        for(i = 0; i < 19200; i++)
        {
                frameBuf[i] = 0xFF;
        }
        
        while(JpegDec.read())
        {
                pImg = JpegDec.pImage ;
                
                for(by=0; by < JpegDec.MCUHeight; by++)
                {
                        for(bx=0; bx < JpegDec.MCUWidth; bx++)
                        {
                                x = JpegDec.MCUx * JpegDec.MCUWidth + bx;
                                y = JpegDec.MCUy * JpegDec.MCUHeight + by;
                                
                                if(x < JpegDec.width && y < JpegDec.height)
                                {
                                        if(JpegDec.comps == 1) // Grayscale
                                        {
                                                //sprintf(str,"#RGB,%d,%d,%u", x, y, pImg[0]);
                                                //Serial.println(str);
                                                
                                                frameBuf[(160 * y) + x] = pImg[0];
                                        }
                                        else // RGB
                                        {
                                                //sprintf(str,"#RGB,%d,%d,%u,%u,%u", x, y, pImg[0], pImg[1], pImg[2]);
                                                //Serial.println(str);
                                                
                                                pxGr = ((pImg[0] * 0.30) + (pImg[1] * 0.59) + (pImg[2] * 0.11));
                                                pxGr_ = (uint8_t)pxGr;
                                                frameBuf[(160 * y) + x] = pxGr_;
                                        }
                                }
                                pImg += JpegDec.comps ;
                        }
                }
        }
        //for(;;);
        Serial.println("JPEG FILE DECODED");
        Serial.println();
}

void setOutput(bool state)
{
  if(state == true)
  {
    digitalWrite(13, 1);
    setFreq(oFreq);
  }
  else
  {
    digitalWrite(13, 0);
    setFreq(oFreq + 340);
  }
}

//8E1 outgoingByte GENERATOR
void timer1_interrupt(void)
{
  byte paritySum;
  static bool bit1;
  static bool bit2;
  static bool bit3;
  static bool bit4;
  static bool bit5;
  static bool bit6;
  static bool bit7;
  static bool bit8;
  static bool parity;
  
  if(snd == 1)
  {
    switch(ti)
    {
      case 0:
        setOutput(false);
        bit1 = outgoingByte & B00000001; paritySum += bit1;
        bit2 = outgoingByte & B00000010; paritySum += bit2;
        bit3 = outgoingByte & B00000100; paritySum += bit3;
        bit4 = outgoingByte & B00001000; paritySum += bit4;
        bit5 = outgoingByte & B00010000; paritySum += bit5;
        bit6 = outgoingByte & B00100000; paritySum += bit6;
        bit7 = outgoingByte & B01000000; paritySum += bit7;
        bit8 = outgoingByte & B10000000; paritySum += bit8;
        if(paritySum % 2 == 0)
        {
          parity = false;
        }
        else
        {
          parity = true;
        }
        break;
      case 10:
        setOutput(bit1);
        break;
      case 20:
        setOutput(bit2);
        break;
      case 30:
        setOutput(bit3);
        break;
      case 40:
        setOutput(bit4);
        break;
      case 50:
        setOutput(bit5);
        break;
      case 60:
        setOutput(bit6);
        break;
      case 70:
        setOutput(bit7);
        break;
      case 80:
        setOutput(bit8);
        break;
      case 90:
        setOutput(parity);
        break;
      case 100:
        setOutput(true);
        break;
      case 110:
        snd = 0;
        break;
    }
    ti++;
  }
}

void loop()
{
        static int  addr;
        static int  lines;
        static byte lineBuf[160];
      
        if(sSq == 0) //--- shot ---
        {
                jpegTake();
                jpegDecode();
                
                //--Adjust Brightness
                for(int p = 0; p < 19200; p++)
                {
                        frameBuf[p] += 0x20;
                        if(frameBuf[p] < 0x20)
                        {
                                frameBuf[p] = 0xFF;
                        }
                }
                lines = 0; sSq = 1;
        }
        if(sSq == 1) //--- prepare/pretone ---
        {
                for(int p = 0; p < 160; p++)
                {
                        lineBuf[p] = frameBuf[(160 * lines) + p];
                }
                /* ---------- */
                checkSum = 0;
                setFreq(oFreq);
                delay(400);
                addr = 0; sSq = 2;
        }
        if(sSq == 2) //--- packet ---
        {
                if(snd == 0)
                {
                        if(addr == 0)
                        {
                                outgoingByte = startMk;
                        }
                        else if(addr == 1)
                        {
                                outgoingByte = LField;
                        }
                        else if(addr == 2)
                        {
                                outgoingByte = LField;
                        }
                        else if(addr == 3)
                        {
                                outgoingByte = startMk;
                        }
                        else if(addr == 4)
                        {
                                CField = lines;
                                /*
                                CField = telegramNumber;
                                CField = CField << 4;
                                bitWrite(CField, 3, 0);
                                bitWrite(CField, 2, 1);
                                bitWrite(CField, 1, 1);
                                bitWrite(CField, 0, 1);
                                */
                                outgoingByte = CField;
                                checkSum += CField;
                        }
                        else if(addr == 5)
                        {
                                outgoingByte = AField;
                                checkSum += AField;
                        }
                        else if(addr == 6)
                        {
                                outgoingByte = CIField;
                                checkSum += CIField;
                        }
                        else if(addr >= 6 + 1 && addr <= 6 + payloadLen)
                        {
                                outgoingByte = lineBuf[addr - 7];
                                checkSum += outgoingByte;
                        }
                        else if(addr == 6 + payloadLen + 1)
                        {
                                outgoingByte = checkSum;
                        }
                        else if(addr == 6 + payloadLen + 2)
                        {
                               outgoingByte = stopMk;
                        }
                        else if(addr > 6 + payloadLen + 2)
                        {
                                /*
                                telegramNumber++;
                                if(telegramNumber == 16)
                                {
                                        telegramNumber = 0;
                                }
                                */
                                sSq = 3;
                                goto intv;
                        }
                        ti = 0; snd = 1;
                        addr++;
                }
        }
        intv: //-- interval --
        if(sSq == 3)
        {
                setFreq(5);
                delay(800);
                lines++;
                if(lines == 120)
                {
                        sSq = 0;
                }
                else
                {
                        sSq = 1;
                }
        }
        delay(5);
}
