// NEO PIXEL TACHO 6
// version 2025.05.02

#include <Adafruit_NeoPixel.h>
#include <LiquidCrystal.h>

//neopixel data output
#define PIN 11

// Parameter 1 = number of pixels in strip
// Parameter 2 = Arduino pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)
Adafruit_NeoPixel strip = Adafruit_NeoPixel(15, PIN, NEO_GRB + NEO_KHZ800);

// IMPORTANT: To reduce NeoPixel burnout risk, add 1000 uF capacitor across
// pixel power leads, add 300 - 500 Ohm resistor on first pixel's data input
// and minimize distance between Arduino and first pixel.  Avoid connecting
// on a live circuit...if you must, connect GND first.

uint32_t c;
uint32_t cR = strip.Color(255, 0, 0);
uint32_t cG = strip.Color(0, 255, 0);
uint32_t c0 = strip.Color(0, 0, 0);

//16x2 lcd display
LiquidCrystal lcd(4,5,6,7,8,9,10);

//A0 -> パルス入力
//A1(=D15) -> スイッチ

void setup()
{
    digitalWrite(15, HIGH); //Internal PULL UP
    
    strip.begin();
    strip.setBrightness(20); //明るさ増減
    strip.show(); // Initialize all pixels to 'off'
    
    lcd.begin(16, 2);
    lcd.setCursor(0, 0);
    lcd.print("LCD READY");
}

void loop()
{
    bool state_1;
    bool state_2;
    long time_1;
    long time_2;
    int count;
    int val;
    bool scale;
    
    time_1 = millis();
    while(true) //wait for start
    {
        val = analogRead(0);
        
        if(val > 127)
        {
             state_2 = true;
        }
        else
        {
             state_2 = false;
        }
        
         if(state_1 == true && state_2 == false) //Falling Edge
        {
             break;
        }
        
        time_2 = millis();
        if(time_2 - time_1 >= 200)
        {
            break;
        }
        
        state_1 = state_2;
    }
    
    time_1 = millis();
    count = 0;
    while(true)
    {
        val = analogRead(0);
        
        if(val > 127)
        {
            state_2 = true;
        }
        else
        {
            state_2 = false;
        }
    
        if(state_1 == false && state_2 == true) //Rising Edge
        {
            count++;
        }
        
        time_2 = millis();
        if(time_2 - time_1 >= 200)
        {
            break;
        }
        
        state_1 = state_2;
    }
    
    lcd.setCursor(0, 1);
    lcd.print("     ");
    lcd.setCursor(0, 1);
    lcd.print(count * 150); //RPM直読
    
    static int lev_1; //ここはstatic
    int lev_2;
    int direc;
    int i;

    //レンジ切り替え
    if(digitalRead(15) == LOW){
         scale = 0;
    }
    else
    {
         scale = 1;
    }
    
    if(scale == 0) //アイドリング監視 フルスケール1500(RPM)
    {
             if(count * 150 <   80){ lev_2 = -1; }
        else if(count * 150 <  180){ lev_2 =  0; }
        else if(count * 150 <  280){ lev_2 =  1; }
        else if(count * 150 <  380){ lev_2 =  2; }
        else if(count * 150 <  480){ lev_2 =  3; }
        else if(count * 150 <  580){ lev_2 =  4; }
        else if(count * 150 <  680){ lev_2 =  5; }
        else if(count * 150 <  780){ lev_2 =  6; }
        else if(count * 150 <  880){ lev_2 =  7; }
        else if(count * 150 <  980){ lev_2 =  8; }
        else if(count * 150 < 1080){ lev_2 =  9; }
        else if(count * 150 < 1180){ lev_2 = 10; }
        else if(count * 150 < 1280){ lev_2 = 11; }
        else if(count * 150 < 1380){ lev_2 = 12; }
        else if(count * 150 < 1480){ lev_2 = 13; }
        else                       { lev_2 = 14; }
    
    }
    else if(scale == 1) //常用域監視 フルスケール3750(RPM)
    {
             if(count * 150 <  230){ lev_2 = -1; }
        else if(count * 150 <  480){ lev_2 =  0; }
        else if(count * 150 <  730){ lev_2 =  1; }
        else if(count * 150 <  980){ lev_2 =  2; }
        else if(count * 150 < 1230){ lev_2 =  3; }
        else if(count * 150 < 1480){ lev_2 =  4; }
        else if(count * 150 < 1730){ lev_2 =  5; }
        else if(count * 150 < 1980){ lev_2 =  6; }
        else if(count * 150 < 2230){ lev_2 =  7; }
        else if(count * 150 < 2480){ lev_2 =  8; }
        else if(count * 150 < 2730){ lev_2 =  9; }
        else if(count * 150 < 2980){ lev_2 = 10; }
        else if(count * 150 < 3230){ lev_2 = 11; } //RED
        else if(count * 150 < 3480){ lev_2 = 12; } //RED
        else if(count * 150 < 3730){ lev_2 = 13; } //RED
        else                       { lev_2 = 14; } //RED
    }

    //増減あれば表示処理
    direc = 0;
    if(lev_2 < lev_1)
    {
        direc = -1;
    }
    else if(lev_2 > lev_1)
    {
        direc = 1;
    }
    
    if(direc == -1)
    {
        for(i = lev_1; i >= lev_2 + 1; i--)
        {
            c = c0;
            strip.setPixelColor(i, c);
            strip.show();
        }
    }
    else if(direc == 1)
    {
        for(i = lev_1; i <= lev_2; i++)
        {
            if(i <= 10)
            {
                c = cG;
            }
            else
            {
                if(scale == 1)
                {
                    c = cR;
                }
                else
                {
                    c = cG;
                }
            }
            strip.setPixelColor(i, c);
            strip.show();
        }
    }
    lev_1 = lev_2;
}
