/****************************************************************
      DCF39/DCF49 PACKET PARSER
          --  EXTENDED FOR 32x32 SSDV RECEPTION
      ARDUINO MEGA 2560
      0.3 TFT
      0.4 bitmap refresh routine
/****************************************************************/

#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_ST7735.h> // Hardware-specific library for ST7735
#include <Adafruit_ST7789.h> // Hardware-specific library for ST7789
#include <SPI.h>

#ifdef ADAFRUIT_HALLOWING
  #define TFT_CS        39 // Hallowing display control pins: chip select
  #define TFT_RST       37 // Display reset
  #define TFT_DC        38 // Display data/command select
  #define TFT_BACKLIGHT  7 // Display backlight pin
#elif defined(ESP8266)
  #define TFT_CS         4
  #define TFT_RST       16                                            
  #define TFT_DC         5
#else
  // For the breakout board, you can use any 2 or 3 pins.
  // These pins will also work for the 1.8" TFT shield.
  #define TFT_CS        10
  #define TFT_RST        9 // Or set to -1 and connect to Arduino RESET pin
  #define TFT_DC         8
#endif

// OPTION 1 (recommended) is to use the HARDWARE SPI pins, which are unique
// to each board and not reassignable. For Arduino Uno: MOSI = pin 11 and
// SCLK = pin 13. This is the fastest mode of operation and is required if
// using the breakout board's microSD card.

// For 1.44" and 1.8" TFT with ST7735 (including HalloWing) use:
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);

// For 1.54" TFT with ST7789:
//Adafruit_ST7789 tft = Adafruit_ST7789(TFT_CS, TFT_DC, TFT_RST);

// OPTION 2 lets you interface the display using ANY TWO or THREE PINS,
// tradeoff being that performance is not as fast as hardware SPI above.
//#define TFT_MOSI 11  // Data out
//#define TFT_SCLK 13  // Clock out
//Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_MOSI, TFT_SCLK, TFT_RST);

float p = 3.1415926;

#include <LiquidCrystal.h>
LiquidCrystal lcd(34,35,36,37,38,39,40);
const byte lcdInfo = 0; //0:incomingByte(ascii) 1:time(CET/CEST)

#include <TimerOne.h>
const byte bdRate = 3; //0:50baud 1:75baud 2:100Bd 3:200Bd

boolean  byteEnd;
byte     ti;
int      x;
byte     y;
char     c[33];

byte     incomingByte;
byte     buff[256];
byte     addr;
boolean  dataBurstEnd;
byte     realLength;
boolean  parityBit;
byte     headParityChk;
byte     bodyParityChk;
byte     frameSq;
byte     LField1;
boolean  lostData;
uint8_t  bitmap[16][64];

volatile int idleTime;

void setup()
{
        lcd.begin(16, 2);
        lcd.cursor();
        lcd.setCursor(0, 0);
        
        Timer1.initialize();
        if(bdRate == 0)
        {
                Timer1.attachInterrupt(timer_interrupt, 2000);
        }
        else if(bdRate == 1)
        {
                Timer1.attachInterrupt(timer_interrupt, 1333);
        }
        else if(bdRate == 2)
        {
                Timer1.attachInterrupt(timer_interrupt, 1000);
        }
        else if(bdRate == 3)
        {
                Timer1.attachInterrupt(timer_interrupt, 500);
        }
        
        Serial.begin(19200);
        
        frameSq = 0;

        /* ---------------------- ADA TFT ---------------------- */
        #ifdef ADAFRUIT_HALLOWING
          // HalloWing is a special case. It uses a ST7735R display just like the
          // breakout board, but the orientation and backlight control are different.
          tft.initR(INITR_HALLOWING);        // Initialize HalloWing-oriented screen
          pinMode(TFT_BACKLIGHT, OUTPUT);
          digitalWrite(TFT_BACKLIGHT, HIGH); // Backlight on
        #else
          // Use this initializer if using a 1.8" TFT screen:
          tft.initR(INITR_BLACKTAB);      // Init ST7735S chip, black tab
        
          // OR use this initializer (uncomment) if using a 1.44" TFT:
          //tft.initR(INITR_144GREENTAB); // Init ST7735R chip, green tab
        
          // OR use this initializer (uncomment) if using a 0.96" 180x60 TFT:
          //tft.initR(INITR_MINI160x80);  // Init ST7735S mini display
        
          // OR use this initializer (uncomment) if using a 1.54" 240x240 TFT:
          //tft.init(240, 240);           // Init ST7789 240x240
        #endif
        
        Serial.println(F("Initialized"));
      
        uint16_t time = millis();
        tft.fillScreen(ST77XX_BLACK);
        time = millis() - time;
      
        Serial.println(time, DEC);
        delay(500);
      
        // large block of text
        /*
        tft.fillScreen(ST77XX_BLACK);
        testdrawtext("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur adipiscing ante sed nibh tincidunt feugiat. Maecenas enim massa, fringilla sed malesuada et, malesuada sit amet turpis. Sed porttitor neque ut ante pretium vitae malesuada nunc bibendum. Nullam aliquet ultrices massa eu hendrerit. Ut sed nisi lorem. In vestibulum purus a tortor imperdiet posuere. ", ST77XX_WHITE);
        delay(1000);
        */
      
        // tft print function!
        tftPrintTest();
        delay(500);
      
        // a single pixel
        /*
        tft.drawPixel(tft.width()/2, tft.height()/2, ST77XX_GREEN);  //真ん中に緑の点
        delay(500);
        */
        
        Serial.println("done");
        delay(500);
        
        tft.fillScreen(ST77XX_BLUE);
}

void testdrawtext(char *text, uint16_t color) {
        tft.setCursor(0, 0);
        tft.setTextColor(color);
        tft.setTextWrap(true);
        tft.print(text);
}

void tftPrintTest() {
        tft.setTextWrap(false);
        tft.fillScreen(ST77XX_BLACK);
        tft.setCursor(0, 30);
        tft.setTextColor(ST77XX_RED);
        tft.setTextSize(1);
        tft.println("Hello World!");
        tft.setTextColor(ST77XX_YELLOW);
        tft.setTextSize(2);
        tft.println("Hello World!");
        tft.setTextColor(ST77XX_GREEN);
        tft.setTextSize(3);
        tft.println("Hello World!");
        tft.setTextColor(ST77XX_BLUE);
        tft.setTextSize(4);
        tft.print(1234.567);
        delay(1500);
        tft.setCursor(0, 0);
        tft.fillScreen(ST77XX_BLACK);
        tft.setTextColor(ST77XX_WHITE);
        tft.setTextSize(0);
        tft.println("Hello World!");
        tft.setTextSize(1);
        tft.setTextColor(ST77XX_GREEN);
        tft.print(p, 6);
        tft.println(" Want pi?");
        tft.println(" ");
        tft.print(8675309, HEX); // print 8,675,309 out in HEX!
        tft.println(" Print HEX!");
        tft.println(" ");
        tft.setTextColor(ST77XX_WHITE);
        tft.println("Sketch has been");
        tft.println("running for: ");
        tft.setTextColor(ST77XX_MAGENTA);
        tft.print(millis() / 1000);
        tft.setTextColor(ST77XX_WHITE);
        tft.print(" seconds.");
}

/*
 * color converter
 * t-hom氏のコードを使わせていただきました。仕組みもわかりやすく解説されています。
 * t-hom's diary https://thom.hateblo.jp/entry/2024/01/14/113914
 */
uint16_t RGB888_to_BGR565(byte red, byte green, byte blue) {
        uint16_t bgr565 = 0;
        bgr565 = blue>>3;
        bgr565 = bgr565<<6;
      
        bgr565 += green>>2;
        bgr565 = bgr565<<5;
      
        bgr565 += red>>3;
        return bgr565;
}

void timer_interrupt(void)
{
        static byte rSq;
        
        ti++;
        if(rSq == 0 && digitalRead(19) == 0)
        {
                rSq = 1;
                ti = 0;
        }
        if(rSq == 1 && ti == 5)
        {
                if(digitalRead(19) == 0)
                {
                        rSq = 2;
                        ti = 0;
                }
                else
                {
                        rSq = 0;
                }
        }
        else if(rSq == 2 && ti == 10)
        {
                bitWrite(incomingByte, 0, digitalRead(19));
        }
        else if(rSq == 2 && ti == 20)
        {
                bitWrite(incomingByte, 1, digitalRead(19));
        }
        else if(rSq == 2 && ti == 30)
        {
                bitWrite(incomingByte, 2, digitalRead(19));
        }
        else if(rSq == 2 && ti == 40)
        {
                bitWrite(incomingByte, 3, digitalRead(19));
        }
        else if(rSq == 2 && ti == 50)
        {
                bitWrite(incomingByte, 4, digitalRead(19));
        }
        else if(rSq == 2 && ti == 60)
        {
                bitWrite(incomingByte, 5, digitalRead(19));
        }
        else if(rSq == 2 && ti == 70)
        {
                bitWrite(incomingByte, 6, digitalRead(19));
        }
        else if(rSq == 2 && ti == 80)
        {
                bitWrite(incomingByte, 7, digitalRead(19));
        }
        else if(rSq == 2 && ti == 90)
        {
                parityBit = digitalRead(19);
                byteEnd = true;
        }
        if(rSq == 2 && ti == 100)
        {
                rSq = 0;
        }
        
        if(digitalRead(19) == 0)
        {
                idleTime = 0;
        }
        else
        {
                idleTime++;
        }
}

//DISPLAYS CHARACTER
void lcdOut()
{
        int i;

        char ch = incomingByte;
        
        //ASCII CODE FILTER
        if(ch < 32 || ch > 126)
        {
                ch = ' ';
        }
        
        lcd.print(ch);
        c[16 * y + x] = ch;
        x++;
        if(x == 16 && y == 0)
        {
                x = 0; y = 1;
        }  
        else if(x == 16 && y == 1)
        {
                for(i = 0; i < 16; i++)
                {
                        c[i] = c[16 + i];
                }
                for(i = 0; i < 16; i++)
                {
                        c[16 + i] = '\0';
                }
                lcd.clear();
                lcd.noCursor();
                for(i = 0; i < 16; i++)
                {
                        lcd.print(c[i]);
                }
                lcd.cursor();
                x = 0; y = 1;
        }
        lcd.setCursor(x, y);
}

//CLEAR BUFFER
void bufClear()
{
        int i;
        for(i = 0; i < 256; i++)
        {
                buff[i] = '\0';
        }
}

//CLEAR BITMAP
void bitmapClear()
{
        int i;
        int j;
        for(i = 0; i < 16; i++)
        {
                for(j = 0; j < 64; j++)
                {
                        bitmap[i][j] = 0x00;
                }
        }
}

void checkAndStore()
{
        byte paritySum;
        byte LField2;
        
        boolean bit7 = incomingByte & B10000000;
        boolean bit6 = incomingByte & B01000000;
        boolean bit5 = incomingByte & B00100000;
        boolean bit4 = incomingByte & B00010000;
        boolean bit3 = incomingByte & B00001000;
        boolean bit2 = incomingByte & B00000100;
        boolean bit1 = incomingByte & B00000010;
        boolean bit0 = incomingByte & B00000001;
        
        Serial.print(bit7);
        Serial.print(bit6);
        Serial.print(bit5);
        Serial.print(bit4);
        Serial.print(bit3);
        Serial.print(bit2);
        Serial.print(bit1);
        Serial.print(bit0);
        
        Serial.print(' ');
        Serial.print(' ');
        Serial.print(parityBit);
        
        //Even Parity Check
        paritySum = 0;
        
        if(bit7){ paritySum++; }
        if(bit6){ paritySum++; }
        if(bit5){ paritySum++; }
        if(bit4){ paritySum++; }
        if(bit3){ paritySum++; }
        if(bit2){ paritySum++; }
        if(bit1){ paritySum++; }
        if(bit0){ paritySum++; }
        if(parityBit){ paritySum++; }
        
        if(paritySum % 2 == 0)
        {
                if(frameSq == 0 && headParityChk < 4)
                {
                        headParityChk++;
                }
                else if(frameSq == 1)
                {
                        bodyParityChk++;
                }
        }
        else
        {
                if(frameSq == 0)
                {
                        headParityChk = 0;
                }
        }
        
        Serial.print(' ');
        Serial.print(' ');
        if(paritySum % 2 == 0)
        {
                Serial.print("OK");
        }
        else
        {
                Serial.print("ER");
        }
        
        Serial.print(' ');
        Serial.print(' ');
        if(incomingByte < 16) {
                Serial.print(0, HEX);
        }
        Serial.print(incomingByte, HEX);

        char ch = incomingByte;
        
        //ASCII CODE FILTER
        if(ch < 32 || ch > 126)
        {
                ch = ' ';
        }

        Serial.print(' ');
        Serial.print(' ');
        Serial.println(ch);
        
        if(frameSq == 0)
        {
                buff[addr] = incomingByte;
                
                //SEEK HEADER
                if(buff[addr - 3] == 0x68 && buff[addr] == 0x68)
                {
                        LField1 = buff[addr - 2];
                        LField2 = buff[addr - 1];
                        if(LField1 == LField2)
                        {
                                if(headParityChk == 4)
                                {
                                        bufClear();
                                        addr = 0;
                                        idleTime = 0;
                                        bodyParityChk = 0;
                                        lostData = false;
                                        frameSq = 1;
                                }
                                else
                                {
                                        addr++;
                                }
                        }
                        else
                        {
                                addr++;
                        }
                }
                else
                {
                        addr++;
                }
        }
        else if(frameSq == 1) //BODY
        {
                buff[addr] = incomingByte;
                
                if(addr == LField1 + 1)
                {
                        frameSq = 2;
                }
                else
                {
                        addr++;
                }
        }
}

void parsePk()
{
        int  i;
        
        byte    CField;
        byte    AField;
        byte    CIField;
        byte    checkSum;
        byte    endMarker;
        int     year;
        byte    month;
        byte    day;
        byte    dOWeek;
        byte    hour;
        boolean summer;
        byte    minute;
        byte    second;
        
        /* ---------- */
        byte        telegramNumber;
        static byte telegramNumber_;
        /* ---------- */
        
        CField     = buff[0x00];
        AField     = buff[0x01];
        CIField    = buff[0x02];
        if(lostData)
        {
                checkSum   = buff[addr - 2];
                endMarker  = buff[addr - 1];
                realLength = addr - 2;
        }
        else
        {
                checkSum   = buff[LField1];
                endMarker  = buff[LField1 + 1];
                realLength = LField1;
        }
        
        Serial.println();
        
        //-- -------------------------------------------- --//
        
        if(AField == 0x00 && CIField == 0x00)
        {
                Serial.println("TIME");
                
                //PARSE TIME
                year   = buff[9] & B01111111;
                year   = year + 2000;
                month  = buff[8] & B00001111;
                day    = buff[7] & B00011111;
                dOWeek = buff[7] & B11100000;
                dOWeek = dOWeek >> 5;
                hour   = buff[6] & B00011111;
                summer = buff[6] & B10000000;
                minute = buff[5] & B00111111;
                second = buff[4] & B11111100;
                second = second >> 2;
                
                Serial.print(year); 
                Serial.print(',');
                if(month < 10)
                {
                        Serial.print('0');
                }
                Serial.print(month); 
                Serial.print(',');
                if(day < 10)
                {
                        Serial.print('0');
                }
                Serial.print(day); 
                switch(dOWeek)
                {
                        case 1:
                                Serial.print(" Mon "); break;
                        case 2:
                                Serial.print(" Tue "); break;
                        case 3:
                                Serial.print(" Wed "); break;
                        case 4:
                                Serial.print(" Thu "); break;
                        case 5:
                                Serial.print(" Fri "); break;
                        case 6:
                                Serial.print(" Sat "); break;
                        case 7:
                                Serial.print(" Sun "); break;
                }
                if(lcdInfo == 1)
                {
                        lcd.clear();
                        if(hour < 10)
                        {
                                lcd.print('0');
                        }
                        lcd.print(hour);
                        lcd.print(':');
                        if(minute < 10)
                        {
                                lcd.print('0');
                        }
                        lcd.print(minute);
                        lcd.print(':');
                        if(second < 10)
                        {
                                lcd.print('0');
                        }
                        lcd.print(second);
                        if(summer)
                        {
                                lcd.print(" CEST");
                        }
                        else
                        {
                                lcd.print(" CET");
                        }
                }
                if(hour < 10)
                {
                        Serial.print('0');
                }
                Serial.print(hour);
                Serial.print(':');
                if(minute < 10)
                {
                        Serial.print('0');
                }
                Serial.print(minute);
                Serial.print(':');
                if(second < 10)
                {
                        Serial.print('0');
                }
                Serial.print(second);
                if(summer)
                {
                        Serial.println(" Summer Time");
                }
                else
                {
                        Serial.println(" Standard Time");
                }
        }
        else if(AField == 0xFF && CIField == 0xFF)
        {
                Serial.println("BROADCAST");
        }
        else if(AField == 0xFF && CIField == 0x02)
        {
                Serial.println("SSDV32");
        }
        else
        {
                Serial.println("COMMAND");
        }
        
        //-- -------------------------------------------- --//
        
        Serial.print("L  Field   : ");
        Serial.print(LField1);
        Serial.print('d');
        
        Serial.print("  / Real L: ");
        Serial.print(realLength);
        Serial.print('d');
        if(lostData)
        {
                Serial.print('*');
        }
        Serial.println();
        
        //-- -------------------------------------------- --//
        
        Serial.print("C  Field   : ");
        if(CField < 16) {
                Serial.print(0, HEX);
        }
        Serial.print(CField, HEX);
        
        telegramNumber = CField & B11110000;
        telegramNumber = telegramNumber >> 4;

        if(AField == 0xFF && CIField == 0xFF)
        {
                Serial.println();
        }
        else
        {
                Serial.print("   / Telegram # ");
                Serial.println(telegramNumber);
        }
        
        //-- -------------------------------------------- --//
        
        Serial.print("A  Field   : ");
        if(AField < 16) {
                Serial.print(0, HEX);
        }
        Serial.println(AField, HEX);
        
        //-- -------------------------------------------- --//
        
        Serial.print("CI Field   : ");
        if(CIField < 16) {
                Serial.print(0, HEX);
        }
        Serial.println(CIField, HEX);
        
        //-- -------------------------------------------- --//
        
        Serial.print("Payload    : ");
        /* ---------- */
        if(telegramNumber < telegramNumber_)
        {
                bitmapClear();
        }
        /* ---------- */
        for(i = 3; i < realLength; i++)
        {
                if(buff[i] < 16) {
                        Serial.print(0, HEX);
                }
                Serial.print(buff[i], HEX);
                Serial.print(' ');
                /* ---------- */
                bitmap[telegramNumber][i - 3] = buff[i]; //push block data
                /* ---------- */
        }
        Serial.print("(");
        for(i = 3; i < realLength; i++)
        {
                //ASCII CODE FILTER
                if(char(buff[i]) < 32 || char(buff[i]) > 126)
                {
                        Serial.print(' ');
                }
                else
                {
                        Serial.print(char(buff[i]));
                }
        }
        Serial.println(')');
        
        //-- -------------------------------------------- --//
        
        Serial.print("Check Sum  : ");
        if(checkSum < 16) {
                Serial.print(0, HEX);
        }
        Serial.print(checkSum, HEX);
        Serial.print(' ');
        
        //CHECK SUM CALC
        uint8_t checkSumCalc;
        
        checkSumCalc += CField;
        checkSumCalc += AField;
        checkSumCalc += CIField;
        for(i = 3; i < realLength; i++)
        {
                checkSumCalc += buff[i];
        }
        
        if(checkSumCalc < 16) {
                Serial.print(0, HEX);
        }
        Serial.print(checkSumCalc, HEX);
        Serial.print(' ');
        if(checkSumCalc == checkSum)
        {
                Serial.println("OK");
        }
        else
        {
                Serial.println("ER");
        }
        
        //-- -------------------------------------------- --//
        
        Serial.print("End Marker : ");
        if(endMarker < 16) {
                Serial.print(0, HEX);
        }
        Serial.print(endMarker, HEX);
        Serial.print(' ');
        if(endMarker == 0x16)
        {
                Serial.println("OK");
        }
        else
        {
                Serial.println("ER");
        }
        
        //-- -------------------------------------------- --//
        
        Serial.print("Parity     : ");
        Serial.print(4 + bodyParityChk);
        Serial.print("/");
        Serial.print(4 + realLength + 2);
        Serial.print(' ');
        if(bodyParityChk == realLength + 2)
        {
                Serial.println("OK");
        }
        else
        {
                Serial.println("ER");
        }
        
        //-- -------------------------------------------- --//
        
        Serial.println();

        int bx;
        int by;
        int px;
        for(by = 0; by < 32; by++)  //0-31
        {
                for(bx = 0; bx < 32; bx++)
                {
                        px = bitmap[(4 * (by / 8)) + (bx / 8)][(8 * (by % 8)) + bx - (8 * (bx / 8))];
                        /*
                        if(by < 8)
                        {
                                     if(bx <  8){ px = bitmap[0][8 * (by % 8) + bx -  0]; }
                                else if(bx < 16){ px = bitmap[1][8 * (by % 8) + bx -  8]; }
                                else if(bx < 24){ px = bitmap[2][8 * (by % 8) + bx - 16]; }
                                else if(bx < 32){ px = bitmap[3][8 * (by % 8) + bx - 24]; }
                        }
                        else if(by < 16)
                        {
                                     if(bx <  8){ px = bitmap[4][8 * (by % 8) + bx -  0]; }
                                else if(bx < 16){ px = bitmap[5][8 * (by % 8) + bx -  8]; }
                                else if(bx < 24){ px = bitmap[6][8 * (by % 8) + bx - 16]; }
                                else if(bx < 32){ px = bitmap[7][8 * (by % 8) + bx - 24]; }
                        }
                        else if(by < 24)
                        {
                                     if(bx <  8){ px = bitmap[ 8][8 * (by % 8) + bx -  0]; }
                                else if(bx < 16){ px = bitmap[ 9][8 * (by % 8) + bx -  8]; }
                                else if(bx < 24){ px = bitmap[10][8 * (by % 8) + bx - 16]; }
                                else if(bx < 32){ px = bitmap[11][8 * (by % 8) + bx - 24]; }
                        }
                        else if(by < 32)
                        {
                                     if(bx <  8){ px = bitmap[12][8 * (by % 8) + bx -  0]; }
                                else if(bx < 16){ px = bitmap[13][8 * (by % 8) + bx -  8]; }
                                else if(bx < 24){ px = bitmap[14][8 * (by % 8) + bx - 16]; }
                                else if(bx < 32){ px = bitmap[15][8 * (by % 8) + bx - 24]; }
                        }
                        */
                             if(px <  0x40){ Serial.print('.');}
                        else if(px <  0x80){ Serial.print(':');}
                        else if(px <  0xC0){ Serial.print('L');}
                        else if(px <= 0xFF){ Serial.print('@');}
                        Serial.print(' ');

                        //3xlarger
                        for(int slideY = 0; slideY < 3; slideY++)
                        {
                                for(int slideX = 0; slideX < 3; slideX++)
                                {
                                        tft.drawPixel(3 * bx + slideX, 3 * by + slideY, RGB888_to_BGR565(px,px,px));
                                }
                        }
                        /*
                        tft.drawPixel(3 * bx + 0, 3 * by + 0, );
                        tft.drawPixel(3 * bx + 1, 3 * by + 0, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 2, 3 * by + 0, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 0, 3 * by + 1, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 1, 3 * by + 1, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 2, 3 * by + 1, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 0, 3 * by + 2, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 1, 3 * by + 2, RGB888_to_BGR565(px,px,px));
                        tft.drawPixel(3 * bx + 2, 3 * by + 2, RGB888_to_BGR565(px,px,px));
                        */
                }
                Serial.println();
        }
        Serial.println();

        telegramNumber_ = telegramNumber;
        bufClear();
        addr = 0;
        headParityChk = 0;
        dataBurstEnd = true;
        frameSq = 0;
}

void loop()
{
        int i;
        
        if(byteEnd)
        {
                if(lcdInfo == 0)
                {
                        lcdOut();
                }
                checkAndStore();
                dataBurstEnd = false;
                byteEnd = false;
        }
        if(frameSq == 0 && idleTime > 100)
        {
                if(dataBurstEnd == false)
                {
                        Serial.println();
                        dataBurstEnd = true;
                }
        }
        else if(frameSq == 1 && idleTime > 100)
        {
                lostData = true;
                parsePk();
        }
        else if(frameSq == 2)
        {
                parsePk();
        }
}

