// EFR Broadcast Packet Sender 50Baud
// 0.2 parity実装 OK
// 0.3 checkSum実装 OK
// 0.4 addrの巻き上げをシンプルに

#include <LiquidCrystal.h>
LiquidCrystal lcd(4,5,6,7,8,9,10);

#include <TimerOne.h>
#define MARK  392   //500000/1530(Hz)
#define SPACE 346   //500000/1190(Hz)

#include <FlexiTimer2.h>

//packet
byte  startMk   = 0x68;            //start marker
byte  LField;                      //length
byte  CField    = 0xFF;            //control, function
byte  AField    = 0xFF;            //a1, address
byte  CIField   = 0xFF;            //a2, control information
char  message[] = "JI3BNB TEST";   //max 16 bytes
byte  msgLen;
byte  checkSum;
byte  stopMk    = 0x16;            //stop marker

//controls
int     sSq;
boolean snd;
int     ti;

//data
char ascii;

void setup()
{
  //pins
  pinMode(12, OUTPUT);  //AFSK AUDIO
  
  //LCD
  lcd.begin(16, 2);

  //timers
  Timer1.initialize();
  FlexiTimer2::set(1, timer2_interrupt);
  FlexiTimer2::start();

  //calculate message length
  int n;
  while(message[n] != '\0')
  {
    n++;
  }
  msgLen = n;
  LField = msgLen + 3;
}

//AFSK TONE GENERATOR
void timer1_interrupt(void)
{
  static boolean toggle;
  
  toggle = toggle ^ 1;
  digitalWrite(12, toggle);
}

//8E1 ASCII GENERATOR
void timer2_interrupt(void)
{
  byte paritySum;
  static bool bit1;
  static bool bit2;
  static bool bit3;
  static bool bit4;
  static bool bit5;
  static bool bit6;
  static bool bit7;
  static bool bit8;
  static bool parity;
  
  if(snd == 1)
  {
    switch(ti)
    {
      case 0:
        Timer1.setPeriod(SPACE);
        bit1 = ascii & B00000001; paritySum += bit1;
        bit2 = ascii & B00000010; paritySum += bit2;
        bit3 = ascii & B00000100; paritySum += bit3;
        bit4 = ascii & B00001000; paritySum += bit4;
        bit5 = ascii & B00010000; paritySum += bit5;
        bit6 = ascii & B00100000; paritySum += bit6;
        bit7 = ascii & B01000000; paritySum += bit7;
        bit8 = ascii & B10000000; paritySum += bit8;
        if(paritySum % 2 == 0)
        {
          parity = false;
        }
        else
        {
          parity = true;
        }
        break;
      case 20:
        if(bit1){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 40:
        if(bit2){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 60:
        if(bit3){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 80:
        if(bit4){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 100:
        if(bit5){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 120:
        if(bit6){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 140:
        if(bit7){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 160:
        if(bit8){Timer1.setPeriod(MARK);}
            else{Timer1.setPeriod(SPACE);}
        break;
      case 180:
        if(parity){Timer1.setPeriod(MARK);}
              else{Timer1.setPeriod(SPACE);}
        break;
      case 200:
        Timer1.setPeriod(MARK);
        break;
      case 220:
        snd = 0;
        break;
    }
    ti++;
  }
}

void loop()
{
  static int addr;
  
  if(sSq == 0) //--- pretone ---
  {
    checkSum = 0;
    lcd.clear();
    Timer1.attachInterrupt(timer1_interrupt, MARK);
    delay(800);
    addr = 0; sSq = 1;
  }
  if(sSq == 1) //--- packet ---
  {
    if(snd == 0)
    {
      if(addr == 0)
      {
        ascii = startMk;
      }
      else if(addr == 1)
      {
        ascii = LField;
      }
      else if(addr == 2)
      {
        ascii = LField;
      }
      else if(addr == 3)
      {
        ascii = startMk;
      }
      else if(addr == 4)
      {
        ascii = CField;
        checkSum += CField;
      }
      else if(addr == 5)
      {
        ascii = AField;
        checkSum += AField;
      }
      else if(addr == 6)
      {
        ascii = CIField;
        checkSum += CIField;
      }
      else if(addr >= 6 + 1 && addr <= 6 + msgLen)
      {
        ascii = message[addr - 7];
        checkSum += ascii;
        lcd.print(ascii);
      }
      else if(addr == 6 + msgLen + 1)
      {
        ascii = checkSum;
      }
      else if(addr == 6 + msgLen + 2)
      {
        ascii = stopMk;
      }
      else if(addr > 6 + msgLen + 2)
      {
        sSq = 2;
        goto intv;
      }
      ti = 0; snd = 1;
      addr++;
    }
  }
  intv: //-- interval --
  if(sSq == 2)
  {
    Timer1.detachInterrupt();
    delay(5000);
    sSq = 0;
  }
  delay(5);
}
